#!/usr/bin/env python
# -*- coding: utf-8 -*-
from utils import *

class View:

    def __init__(self):
        self.cms = 'background'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self ):
        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        dic.close()

        if scfg.get("PAGEMAKE"):
            if scfg.get("PAGEMAKE") == 'HTML':
                pages = GetHtmlMenuPages() 

        return render.background( 
                                    cms = self.cms,                        
                                    scfg = scfg, 
                                    pages = pages,
                                    mode = 'view',
                                    id = None,
                                    html_file = None,
        )

class Edit:

    def __init__(self):
        self.cms = 'background'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self, id="index" ):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        fields = dic.get('fields')
        dic.close()

        try:
            file = codecs.open(PANEO_SITE_DATA_DIR+id+'.html',"r","utf8")
            bs = BeautifulSoup(file.read(),"html5lib",fromEncoding="utf8")
            file.close()
        except:
            return web.notfound()

        if fields is None:
            fields = {}

        html_fields = {}
        n = 0
        bks =  bs.find_all(attrs={'data-paneo-type':'background'})
        for bk in bks:
            bk_id = bk.get('id')
            if bk.name == 'body':
                bk_id = 'body'
            bk_title = bk.get('title')
            bk_url = bk.get('data-paneo-background-url')
            if bk_url is None:
                bk_url = ""
            if bk_id is not None :
                k = ('bk_%s_%s_img'%(id,bk_id))
                f = fields.get(k)
                if f :
                    bk_url = f.get('url') 
                    bk_src = f.get('src') 
                    bk_src_on = f.get('src_on') 
                    bk_size = f.get('size') 
                    bk_repeat = f.get('repeat') 
                    bk_position = f.get('position') 
                    bk_etc = f.get('etc') 
                else:
                    bk_url = bk_url 
                    bk_src = bk_url 
                    bk_src_on = False 
                    bk_size = "cover"
                    bk_repeat = "no-repeat"
                    bk_position = "0 0"
                    bk_etc = ""

                #画像があるかどうかチェック
                if os.path.exists(PANEO_SITE_DATA_DIR+'img/'+k) :
                    if bk_src_on is False:
                        bk_url = "/" + PANEO_SITE_DIR + "/img/" + k + "?" + dt

                html_fields[k] = {  'idx':n ,
                                    'tag':bk.name,
                                    'title':bk_title,
                                    'id':bk_id,
                                    'url':bk_url,
                                    'src':bk_src,
                                    'src_on':bk_src_on,
                                    'size':bk_size,
                                    'repeat':bk_repeat,
                                    'position':bk_position,
                                    'etc':bk_etc,
                                } 
                n = n + 1

        return render.background(  
                                    cms = self.cms,                        
                                    mode = 'edit',
                                    id = id,
                                    scfg = scfg, 
                                    pages = pages,
                                    bs = bs,
                                    html_fields = html_fields,
                                    dt = dt,
        )


    def POST( self, id="index" ):

        i = web.input()

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        fields = dic.get('fields')

        try:
            file = codecs.open(PANEO_SITE_DATA_DIR+id+'.html',"r","utf8")
            bs = BeautifulSoup(file.read(),"html5lib",fromEncoding="utf8")
            file.close()
        except:
            pass

        if fields is None:
            fields = {}

        bks =  bs.find_all(attrs={'data-paneo-type':'background'})
        for bk in bks:
            bk_id = bk.get('id')
            if bk.name == 'body':
                bk_id = 'body'
            bk_title = bk.get('title')
            bk_url = bk.get('data-paneo-background-url')
            if bk_url is None:
                bk_url = ""
            if bk_id is not None:
                k = ('bk_%s_%s_img'%(id,bk_id))
                #画像の削除
                if i.has_key(k+'_file_del'):
                    if os.path.exists(PANEO_SITE_DATA_DIR + "img/" + k):
                        os.remove(PANEO_SITE_DATA_DIR + "img/" + k)

                if i.has_key(k+'_file'):
                    if i[k+'_file'] != "":
                        fout = open(PANEO_SITE_DATA_DIR + "img/" + k,'wb') 
                        fout.write(i[k+'_file']) 
                        fout.close() 

                #background css data
                if i[k + '_src'] != "":
                    bk_src =  i[k+'_src']
                else:
                    bk_src = bk_url 

                if i[k + '_size'] != "":
                    bk_size =  i[k+'_size']
                else:
                    bk_size = bk.get('size')

                if i[k + '_repeat'] != "":
                    bk_repeat =  i[k+'_repeat']
                else:
                    bk_repeat = bk.get('repeat')

                if i[k + '_position'] != "":
                    bk_position =  i[k+'_position']
                else:
                    bk_position = bk.get('position')
                    
                if i[k + '_etc'] != "" and i[k+'_etc'] is not None :
                    bk_etc =  i[k+'_etc']
                else:
                    bk_etc = bk.get('etc')

                fields[k] = {
                        'tag':bk.name,
                        'title':bk_title,
                        'id':bk_id,
                        'url':bk_url,
                        'src':bk_src,
                        'src_on':i.has_key(k+'_src_on'),
                        'size':bk_size,
                        'repeat':bk_repeat,
                        'position':bk_position,
                        'etc':bk_etc,
                }
                dic['fields'] = fields

        dic.close()
       
        return self.GET( id )

